state IceBlast in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var energy_area   									: SpellsEnergyArea;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3EnergyDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;
	var randRoll										: float;


	event OnEnterState( prevStateName : name )
	{
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_iceblast();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_iceblast()
	{
		var venom						: W3GreatSwampVenom;
		var effect1,effect2				: CEntity;
		var elactors					: array<CActor>;
		var elactor0,elactor1			: CActor;
		var meteorPosition				: Vector;
		var nbr, g						: int;
		var speed 						: float;
		var blastentity 				: W3IceBlastSpell;
		var marker					 	: CEntity;
		var randYaw						: float;
	
		if ( parent.spell_name == 'iceblast' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
			
				targetPosition = parent.actor.GetWorldPosition();
				targetPosition.Z+=2;
				randYaw = RandRangeF( 180.0, -180.0 );
				rotation.Yaw = randYaw;
				blastentity = (W3IceBlastSpell)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\ice_blast.w2ent", true ), targetPosition, rotation );
				blastentity.Appear();
				
				rotation = parent.actor.GetWorldRotation();
				effect1 = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'ice_spikes_large' ), TraceFloor(targetPosition), rotation );
				effect1.DestroyAfter(30);
			
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}